#include "main.h"

float fabs(float n);

list<_particle> particles;

void new_particle(int type, int x, int y, float xv, float yv, string txt)
{
	_particle p;
	p.init(type, float(x), float(y), xv, yv, txt);
	particles.push_back(p);
}

void do_particles()
{
	list<_particle>::iterator it;
	it = particles.begin();
	while (it != particles.end())
	{
		if ((*it).exists)
		{
			(*it).do_stuff();
			(*it).draw();
		}
		else
		{
			it = particles.erase(it);
			it--;
		}
		it++;
	}
}

void _particle::init(short atype, float ax, float ay, float axv, float ayv, string txt)
{
	int i, a, b;
  type = atype;
  x = ax;
  y = ay;
  xv = axv;
  yv = ayv;
	xa = 0;
	ya = 0;
  text = txt;
	exists = true;
  switch (type)
  {
    case P_STAR:
      life = 50;
      break;
		case P_ENGINE:
			life = 2 + rand()%8;
			i = rand()%3;
			if (i == 0)
			{
				color = RED;
			}
			else if (i == 1)
			{
				color = ORANGE;
			}
			else if (i == 2)
			{
				color = YELLOW;
			}
			break;
		case P_TEXT:
			life = 60;
			break;
		case P_EXPLODE:
			if (!player.insane)
			{
				life = 10;
			}
			else
			{
				life = 0;
				i = 0;
				while (i < 5)
				{
					a = rand()%2;
					if (a == 0) a = -1;
					b = rand()%2;
					if (b == 0) b = -1;
					new_particle(P_BANANA, int(x), int(y), float(a * (rand()%7 + 4)), float(b * (rand()%7 + 4)));
					i++;
				}
			}
			break;
		case P_COW:
		case P_BANANA:
			life = 100;
			w = 0;
			ya = 0.45;
			break;
    default:
      life = 0;
      break;
  }
}

void _particle::do_stuff()
{
	int a, b;
	
	if ((player.insane) && (type == P_STAR))
	{
		a = rand()%2;
		if (a == 0) a = -1;
		b = rand()%2;
		if (b == 0) b = -1;
		x += float(a * rand()%10);
		y += float(b * rand()%10);
	}
	else
	{
		x += xv;
  	y += yv;
		xv += xa;
		yv += ya;
	}

  switch (type)
  {
    case P_STAR:
      if ((x < 0) || (x > 640) || (y < 0) || (y > 480))
      {
        exists = false;
				if (player.insane)
				{
					new_particle(P_STAR, rand()%640, rand()%480, 0, 1 + float(rand()%100) / 10.0);
				}
      }
      life++;
      break;
		case P_ENGINE:
			break;
		case P_TEXT:
			break;
		case P_COW:
			w += 3;
			if (w > 255) w = 0;
			break;
		case P_BANANA:
			w += 10;
			if (w > 255) w = 0;
			if (x < 0) xv = fabs(xv);
			if (x > 620) xv = -fabs(xv);
			break;
  }
  life--;
  if (life <= 0)
  {
    exists = false;
  }
}

void _particle::draw()
{
  switch (type)
  {
    case P_STAR:
      buffer_putpixel(int(x), int(y), WHITE);
      break;
		case P_ENGINE:
			buffer_putpixel(int(x), int(y), color);
			break;
		case P_TEXT:
			buffer_textout_centre_ex(font, text, int(x), int(y), WHITE);
			break;
		case P_EXPLODE:
			buffer_circlefill(int(x), int(y), 10 - life, RED);
			buffer_circlefill(int(x), int(y), 5 - life, YELLOW);
			break;
		case P_COW:
			buffer_rotate_sprite(cow, int(x), int(y), ftofix(w));
			break;
		case P_BANANA:
			buffer_rotate_sprite(banana, int(x), int(y), ftofix(w));
			break;
  }
}

float fabs(float n)
{
	if (n < 0) return -n;
	return n;
}
